/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.util.List;

/**
 * GAufnahmeIF
 *
 * @author Arno
 * @version $Id: GAufnahmeIF.java,v 1.1.4.1 2007/02/24 17:03:06 java Exp $
 */
public interface GAufnahmeIF {

    public static final String EXTENSION = ".mpg";

    public void readAufnahme();
    
    public int getStatus();

    public int getStartzeit();

    public int getEndezeit();

    public boolean istGesperrt();

    public int getSerienID();
    
    public String getTitel();

    public String getOriginalTitel();

    public String getExtension();

    public String[] getDateinamenBasen();

    public int getAufnahmeBeginn();

    public String getInfo();

    public String getInhalt();

    public int getGesehenBis();

    public String getSender();

    public List getMpgFiles();
    
    public long getByte();

    public String getCridFilename();

    public String toString();
    
    public int getFolgeNr();

    public void setFolgeNr(int inpFolgeNr);
    
    public boolean isSerie();
    
    public void setSerie(boolean inpB);
    
    /**
     * @return anzahlFMPGsErwartet
     */
    public int getAnzahlFMPGsErwartet();

    /**
     * @return anzahlFMPGsVorhanden
     */
    public int getAnzahlFMPGsVorhanden();

    public int getAnzahlMPGsErwartet();
    
    public int getAnzahlMPGsVorhanden();
    
    public boolean isFehlerhaft();
    
    public boolean isLaufend();
    
    public boolean isValid();
    
}